package gov.va.med.mhv.mrp.service.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.data.model.MyGoalsExtensions;
import gov.va.med.mhv.mrp.data.model.MyGoalsTasks;

@Component
public class MyGoalExtensionsConverter implements Converter<MyGoalsExtensions, MyGoalsExtensionDTO> {

	@Autowired
	private MyGoalTaskConverter myGoalTaskConverter;

	@Override
	public MyGoalsExtensionDTO convert(MyGoalsExtensions e) {
		MyGoalsExtensionDTO dto = new MyGoalsExtensionDTO();

		dto.setDescription(e.getDescription());
		dto.setGoalExtensionId(e.getGoalExtensionId());
		dto.setGoalExtensionSequenceNumber(e.getGoalExtensionSequenceNumber());
		dto.setGoalExtensionType(e.getGoalExtensionType());
		dto.setOplock(e.getOplock());

		if (e.getMyGoalsTasks() != null) {
			for (MyGoalsTasks task : e.getMyGoalsTasks()) {
				MyGoalTaskDTO taskDTO = myGoalTaskConverter.convert(task);
				dto.getMyGoalsTasks().add(taskDTO);
			}
		}

		return dto;
	}

}
